/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher;

import club.sk1er.modcore.ModCoreInstaller;
import club.sk1er.mods.core.gui.notification.Notifications;
import club.sk1er.mods.core.util.Multithreading;
import club.sk1er.mods.core.util.WebUtil;
import club.sk1er.patcher.command.CoordsCommand;
import club.sk1er.patcher.command.FovChangerCommand;
import club.sk1er.patcher.command.InventoryScaleCommand;
import club.sk1er.patcher.command.PatcherCommand;
import club.sk1er.patcher.command.SkinCacheRefresh;
import club.sk1er.patcher.config.PatcherConfig;
import club.sk1er.patcher.config.PatcherSoundConfig;
import club.sk1er.patcher.coroutines.MCDispatchers;
import club.sk1er.patcher.hooks.MinecraftHook;
import club.sk1er.patcher.screen.PatcherMenuEditor;
import club.sk1er.patcher.screen.render.DebugPerformanceRenderer;
import club.sk1er.patcher.screen.render.TitleFix;
import club.sk1er.patcher.screen.tab.MenuPreviewHandler;
import club.sk1er.patcher.tweaker.PatcherTweaker;
import club.sk1er.patcher.tweaker.asm.GuiChatTransformer;
import club.sk1er.patcher.util.armor.ArmorStatusRenderer;
import club.sk1er.patcher.util.chat.ChatHandler;
import club.sk1er.patcher.util.chat.ImagePreview;
import club.sk1er.patcher.util.enhancement.EnhancementManager;
import club.sk1er.patcher.util.enhancement.ReloadListener;
import club.sk1er.patcher.util.fov.FovHandler;
import club.sk1er.patcher.util.hotbar.HotbarItemsHandler;
import club.sk1er.patcher.util.keybind.KeybindChatPeek;
import club.sk1er.patcher.util.keybind.KeybindDropModifier;
import club.sk1er.patcher.util.keybind.KeybindNameHistory;
import club.sk1er.patcher.util.screenshot.AsyncScreenshots;
import club.sk1er.patcher.util.screenshot.viewer.Viewer;
import club.sk1er.patcher.util.sound.SoundHandler;
import club.sk1er.patcher.util.status.ProtocolDetector;
import club.sk1er.patcher.util.world.WorldHandler;
import club.sk1er.patcher.util.world.cloud.CloudHandler;
import club.sk1er.patcher.util.world.entity.EntityRendering;
import club.sk1er.patcher.util.world.entity.EntityTrace;
import club.sk1er.patcher.util.world.entity.culling.EntityCulling;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.command.ICommand;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="patcher", name="Patcher", version="1.5.1", acceptedMinecraftVersions="[1.8.9]")
public class Patcher {
    public static final String VERSION = "1.5.1";
    @Mod.Instance(value="patcher")
    public static Patcher instance;
    private final Logger logger = LogManager.getLogger((String)"Patcher");
    private final File logsDirectory;
    private final Set<String> blacklistedServers;
    private final File blacklistedServersFile;
    private final CloudHandler cloudHandler;
    private final DebugPerformanceRenderer debugPerformanceRenderer;
    private final Viewer viewer;
    private KeyBinding dropModifier;
    private KeyBinding nameHistory;
    private KeyBinding chatPeek;
    private PatcherConfig patcherConfig;
    private PatcherSoundConfig patcherSoundConfig;
    private JsonObject duplicateModsJson;
    private boolean loadedGalacticFontRenderer;

    public Patcher() {
        this.logsDirectory = new File(Minecraft.func_71410_x().field_71412_D + File.separator + "/" + File.separator + "logs" + File.separator);
        this.blacklistedServers = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        this.blacklistedServersFile = new File("./config/blacklisted_servers.txt");
        this.cloudHandler = new CloudHandler();
        this.debugPerformanceRenderer = new DebugPerformanceRenderer();
        this.viewer = new Viewer();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        ModCoreInstaller.initializeModCore(Minecraft.func_71410_x().field_71412_D);
        this.nameHistory = new KeybindNameHistory();
        ClientRegistry.registerKeyBinding((KeyBinding)this.nameHistory);
        this.dropModifier = new KeybindDropModifier();
        ClientRegistry.registerKeyBinding((KeyBinding)this.dropModifier);
        this.chatPeek = new KeybindChatPeek();
        ClientRegistry.registerKeyBinding((KeyBinding)this.chatPeek);
        this.patcherConfig = new PatcherConfig();
        this.patcherConfig.preload();
        this.patcherSoundConfig = new PatcherSoundConfig();
        this.patcherSoundConfig.preload();
        SoundHandler target = new SoundHandler();
        IReloadableResourceManager resourceManager = (IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L();
        resourceManager.func_110542_a((IResourceManagerReloadListener)target);
        resourceManager.func_110542_a((IResourceManagerReloadListener)new ReloadListener());
        this.registerCommands(new ICommand[]{new PatcherCommand(), new FovChangerCommand(), new SkinCacheRefresh(), new CoordsCommand(), new InventoryScaleCommand(), new AsyncScreenshots.FavoriteScreenshot(), new AsyncScreenshots.DeleteScreenshot(), new AsyncScreenshots.UploadScreenshot(), new AsyncScreenshots.CopyScreenshot(), new AsyncScreenshots.ScreenshotsFolder()});
        this.registerEvents(this, target, this.viewer, this.debugPerformanceRenderer, this.cloudHandler, this.dropModifier, new MenuPreviewHandler(), new EntityRendering(), new FovHandler(), new ChatHandler(), new HotbarItemsHandler(), new EntityCulling(), new ArmorStatusRenderer(), new EntityTrace(), new PatcherMenuEditor(), new ImagePreview(), new WorldHandler(), new TitleFix(), MinecraftHook.INSTANCE);
        this.checkLogs();
        this.loadBlacklistedServers();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (!this.loadedGalacticFontRenderer) {
            this.loadedGalacticFontRenderer = true;
            Minecraft.func_71410_x().field_71464_q.func_78276_b("Force Load", 0, 0, 0);
        }
        MCDispatchers.INSTANCE.getIO().close();
    }

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent event) {
        List activeModList = Loader.instance().getActiveModList();
        Notifications notifications = Notifications.INSTANCE;
        for (ModContainer container : activeModList) {
            String modId = container.getModId();
            String modName = container.getName();
            if (PatcherConfig.entityCulling && modId.equals("enhancements")) {
                notifications.pushNotification("Patcher", modName + " has been detected. Entity Culling is now disabled.\nThis is an unfixable incompatibility without an update from the authors of " + modName);
                PatcherConfig.entityCulling = false;
            }
            if (modId.equals("labymod")) {
                if (PatcherConfig.compactChat) {
                    notifications.pushNotification("Patcher", "Labymod has been detected. Compact Chat is now disabled.\nThis is an unfixable incompatibility without an update from the authors of " + modName);
                    PatcherConfig.compactChat = false;
                }
                if (PatcherConfig.optimizedResourcePackDiscovery) {
                    notifications.pushNotification("Patcher", "Labymod has been detected. Optimized Resource Pack Discovery is now disabled.\nThis is an unfixable incompatibility without an update from the authors of " + modName);
                    PatcherConfig.optimizedResourcePackDiscovery = false;
                }
            }
            if (PatcherConfig.optimizedFontRenderer && modId.equals("smoothfont")) {
                notifications.pushNotification("Patcher", "Patcher has identified Smooth Font and as such, Patcher's Optimized Font Renderer has been automatically disabled.\nRestart your game for Smooth Font to work again.");
                PatcherConfig.optimizedFontRenderer = false;
            }
            this.forceSaveConfig();
        }
        if (PatcherConfig.replacedModsWarning) {
            Multithreading.runAsync(() -> {
                try {
                    this.duplicateModsJson = new JsonParser().parse(WebUtil.fetchString((String)"https://static.sk1er.club/patcher/duplicate_mods.json")).getAsJsonObject();
                }
                catch (Exception e) {
                    this.logger.error("Failed to fetch list of duplicate mods.", (Throwable)e);
                    return;
                }
                HashSet<String> duplicates = new HashSet<String>();
                for (ModContainer modContainer : activeModList) {
                    for (String modid : this.keySet(this.duplicateModsJson)) {
                        if (!modContainer.getModId().contains(modid) || duplicates.contains(modid)) continue;
                        duplicates.add(modContainer.getName());
                    }
                }
                if (!duplicates.isEmpty()) {
                    for (String duplicate : duplicates) {
                        notifications.pushNotification("Patcher", "Patcher has identified the mod " + duplicate + " to be a duplicate.\nThis message can be disabled in the Patcher settings.");
                    }
                }
            });
        }
        long time = (System.currentTimeMillis() - PatcherTweaker.clientLoadTime) / 1000L;
        if (PatcherConfig.startupNotification) {
            notifications.pushNotification("Minecraft Startup", "Minecraft started in " + time + " seconds.");
        }
        this.logger.info("Minecraft started in {} seconds.", new Object[]{time});
    }

    @SubscribeEvent
    public void connectToServer(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        if (event.isLocal) {
            this.logger.info("User is in singleplayer, setting string length to 256.");
            GuiChatTransformer.maxChatLength = 256;
            return;
        }
        String serverIP = Minecraft.func_71410_x().func_147104_D().field_78845_b;
        if (serverIP == null) {
            this.logger.info("Server IP is somehow null, returning.");
            return;
        }
        if (this.blacklistedServers.contains(serverIP)) {
            this.logger.info("Current server supports 1.11+, but doesn't allow for 1.8.9 to use a high chat length, setting to 100.");
            GuiChatTransformer.maxChatLength = 100;
            return;
        }
        CompletableFuture<Boolean> future = ProtocolDetector.instance.isCompatibleWithVersion(serverIP, 315);
        Multithreading.runAsync(() -> {
            try {
                GuiChatTransformer.maxChatLength = (Boolean)future.get() != false ? 256 : 100;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent event) {
        EnhancementManager.getInstance().tick();
    }

    private void checkLogs() {
        if (PatcherConfig.logOptimizer) {
            for (File file : Objects.requireNonNull(this.logsDirectory.listFiles())) {
                if (file.lastModified() > System.currentTimeMillis() - (long)PatcherConfig.logOptimizerLength * 86400000L) continue;
                this.logger.info("Deleted log {}", new Object[]{file.getName()});
                file.delete();
            }
        }
    }

    private void registerEvents(Object ... events) {
        for (Object event : events) {
            MinecraftForge.EVENT_BUS.register(event);
        }
    }

    private void registerCommands(ICommand ... commands) {
        for (ICommand command : commands) {
            ClientCommandHandler.instance.func_71560_a(command);
        }
    }

    private boolean isServerBlacklisted(String ip) {
        return ip != null && !ip.isEmpty() && !ip.trim().isEmpty() && this.blacklistedServers.contains(ip.trim());
    }

    public boolean addOrRemoveBlacklist(String input) {
        if (input == null || input.isEmpty() || input.trim().isEmpty()) {
            return false;
        }
        if (this.isServerBlacklisted(input = input.trim())) {
            this.blacklistedServers.remove(input);
            return false;
        }
        this.blacklistedServers.add(input);
        return true;
    }

    public void saveBlacklistedServers() {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.blacklistedServersFile));){
            if (!this.blacklistedServersFile.getParentFile().exists() && !this.blacklistedServersFile.getParentFile().mkdirs()) {
                return;
            }
            if (!this.blacklistedServersFile.exists() && !this.blacklistedServersFile.createNewFile()) {
                return;
            }
            for (String server : this.blacklistedServers) {
                writer.write(server + System.lineSeparator());
            }
        }
        catch (IOException e) {
            this.logger.error("Failed to save blacklisted servers.", (Throwable)e);
        }
    }

    private void loadBlacklistedServers() {
        if (!this.blacklistedServersFile.exists()) {
            return;
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(this.blacklistedServersFile));){
            String servers;
            while ((servers = reader.readLine()) != null) {
                this.blacklistedServers.add(servers);
            }
        }
        catch (IOException e) {
            this.logger.error("Failed to load blacklisted servers.", (Throwable)e);
        }
    }

    public Set<String> keySet(JsonObject json) throws NullPointerException {
        HashSet<String> keySet = new HashSet<String>();
        for (Map.Entry entry : json.entrySet()) {
            keySet.add((String)entry.getKey());
        }
        return keySet;
    }

    public PatcherConfig getPatcherConfig() {
        return this.patcherConfig;
    }

    public PatcherSoundConfig getPatcherSoundConfig() {
        return this.patcherSoundConfig;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public CloudHandler getCloudHandler() {
        return this.cloudHandler;
    }

    public KeyBinding getNameHistory() {
        return this.nameHistory;
    }

    public KeyBinding getChatPeek() {
        return this.chatPeek;
    }

    public KeyBinding getDropModifier() {
        return this.dropModifier;
    }

    public DebugPerformanceRenderer getDebugPerformanceRenderer() {
        return this.debugPerformanceRenderer;
    }

    public Viewer getViewer() {
        return this.viewer;
    }

    public void forceSaveConfig() {
        this.patcherConfig.markDirty();
        this.patcherConfig.writeData();
    }
}

